#include <iostream>
#include <unordered_map>

struct AxisCount { int even = 0; int odd = 0; };

int main() {
    int count;
    std::cin >> count;
    std::unordered_map<long, int> hashmap1;
    std::unordered_map<long, int> hashmap2;
    std::unordered_map<long, AxisCount> hashmapX;
    std::unordered_map<long, AxisCount> hashmapY;

    for (int i = 0; i < count; i++) {
        int x, y;
        std::cin >> x >> y;
        hashmap1[x - y]++;
        hashmap2[x + y]++;
        if (y % 2) hashmapX[x].odd++;
        else hashmapX[x].even++;
        if (x % 2) hashmapY[y].odd++;
        else hashmapY[y].even++;
    }

    int greetings = 0;

    for (const std::pair x : hashmap1)
        greetings += x.second * (x.second - 1);
    for (const std::pair x : hashmap2)
        greetings += x.second * (x.second - 1);
    for (const std::pair x : hashmapX)
        greetings += (x.second.odd * (x.second.odd - 1) + x.second.even * (x.second.even - 1)) / 2;
    for (const std::pair x : hashmapY)
        greetings += (x.second.odd * (x.second.odd - 1) + x.second.even * (x.second.even - 1)) / 2;

    std::cout << greetings;
}